"""
    Example script for establishing a connection to the SLSS CANAnalyser software
    and demonstrates a specified COM port connection and custom CAN FD configuration
    as well as showing TCP/IP monitored CAN data.
    This example serves as an introduction to using the SLSS CANAnalyser TCP/IP Class.

    IMPORTANT: Please ensure that the TCP/IP interface is activated in the SLSS CANAnalyser.
"""
__author__      =   "Ron Zlotnik"
__company__     =   "Sebastian Langer Software Solutions UG (haftungsbeschraenkt), SeRoSys Technology LLC"
__credits__     =   "Sebastian Langer and Ron Zlotnik"
__dev_date__    =   "2025.01.20"
__version__     =   "1.0.0.0"
__email__       =   "info@langer-sebastian.de, slanger@serosys-tech.com, rzlotnik@serosys-tech.com"
__status__      =   "production"
__copyright__   =   "Sebastian Langer @ Sebastian Langer Software Solutions UG (haftungsbeschraenkt)"

""" USER SETTINGS AND SLSS CANANALYSER INITIALIZATION """

from cls.cl_SLSS_CANAnalyser_TCPIP_Interface import CANAnalyserTCPIP    # import the class to the current script
slss_com = CANAnalyserTCPIP("127.0.0.1", 49836, True, True)  # Create an instance using the local host IP (this computer) and port 49836
                                                             # (must match the port set in the SLSS CANAnalyser) with immediate establishment
                                                             # of the connection and activated log output.

""" SLSS CANANALYSER COMMANDS """

slss_com.disconnect_module()  # Begins by disconnecting a dongle (in case one is already connected)

slss_com.set_FD_custom_state("AB", True)  # Activate the FD custom settings
slss_com.set_FD_custom_settings("AB", "80", 127, 32, 32, 12, 1, 1, 15, 4, 4)  # Configuration parameters for the custom FD settings

slss_com.set_FD_active_state("AB", True)  # set FD active state to True to use CAN FD

slss_com.set_speed("A", "1000")  # set CAN speed of channel A to 1000kbit/s
slss_com.set_speed("B", "500")  # set CAN speed of channel B to 500kbit/s

slss_com.set_mode("AB", "normal")  # set bus interaction mode for both bus channels to normal

slss_com.mute_CAN("AB")  # mute CAN channels A and B to send CAN data over TCP/IP

slss_com.connect_module(3)   # Connect to Dongle which has is assigned to COM port 3

slss_com.set_runstate("play")

if "not connected" in slss_com.get_connection():  # check if a dongle connection could be established
    print("ERROR: No Dongle connection could be established --> execution aborted!")
    exit(1)
else:
    print("Well done! The settings have been set and the connection to the Dongle has been successfully established!")