"""
    Example script for modifying a DBC signal in the DBC send grid and optionally send it to the bus.
    This example serves as an introduction to using the SLSS CANAnalyser TCP/IP Class.

    IMPORTANT: Please ensure that the TCP/IP interface is activated in the SLSS CANAnalyser.
"""
__author__      =   "Sebastian Langer"
__company__     =   "Sebastian Langer Software Solutions UG (haftungsbeschraenkt), SeRoSys Technology LLC"
__credits__     =   "Sebastian Langer"
__dev_date__    =   "2025.09.09"
__version__     =   "1.0.0.0"
__email__       =   "info@langer-sebastian.de, slanger@serosys-tech.com"
__status__      =   "production"
__copyright__   =   "Sebastian Langer @ Sebastian Langer Software Solutions UG (haftungsbeschraenkt)"

from time import sleep

""" USER SETTINGS AND SLSS CANANALYSER INITIALIZATION """

from cls.cl_SLSS_CANAnalyser_TCPIP_Interface import CANAnalyserTCPIP    # import the class to the current script
slss_com = CANAnalyserTCPIP("127.0.0.1", 49600, True, True)  # Create an instance using the local host IP (this computer) and port 49836
                                                             # (must match the port set in the SLSS CANAnalyser) with immediate establishment
                                                             # of the connection and activated log output.

""" SLSS CANANALYSER COMMANDS """

# NOTE: The following example is based on the loaded DBC files for the SeRoSys CAN FD Injector.
# Please align message and signal names to your messages shown in the Send DBC Signals tab!

for i in range(1,11):
    slss_com.send_DBC_message("B", "Vehicle_Messages", "Speed", (i*10))
    slss_com.send_DBC_message("B", "Vehicle_Messages", "TRANS", 2.00)
    slss_com.send_DBC_message("B", "Vehicle_Messages", "Revs", ((i*100) + 800))
    sleep(1)